#include "maindefs.h"
#include "pwm.h"
#include <pwm.h>

void pwm_init() {
    // Configure pins RC5 and RC7 as outputs
    TRISCbits.TRISC0 = 0;
    TRISCbits.TRISC1 = 0;
    TRISCbits.TRISC2 = 0;
    LATCbits.LATC0 = 0;
    LATCbits.LATC1 = 0;
    LATCbits.LATC2 = 0;

    RPOR11 = 14;    // Set RP11 to ECCP1 PWM Output Channel A
    RPOR12 = 15;    // Set RP12 to ECCP1 PWM Output Channel B
#ifdef _REMOTE
    RPOR13 = 18;    // Set RP13 to ECCP2 PWM Output
#endif
}

void pwm_IR_start() {
    OpenPWM1(0x3D);  // 38kHz frequency
    SetDCPWM1(0x80);  // 50% duty cycle

    // Wait for completion of a full PWM cycle before enabling output mode
    while(!PIR1bits.TMR2IF);
    SetOutputPWM1(SINGLE_OUT, PWM_MODE_1);

    // Enable ECCP1 output channels A and B
    PSTR1CONbits.STRA = 1;
    PSTR1CONbits.STRB = 1;
}

void pwm_IR_stop() {
    ClosePWM1();
}

void pwm_LED_on() {
#ifdef _REMOTE
    OpenPWM2(0xFF);     // Full period from timer
    SetDCPWM2(0x80);    // 50% duty cycle
    PSTR2CONbits.STRA = 1;  // Enable output channel A
#endif
#ifdef _BASE_STATION
    LATCbits.LATC2 = 1;
#endif
    PWM_LED_STATE = 1;
}

void pwm_LED_off() {
#ifdef _REMOTE
    ClosePWM2();
#endif
#ifdef _BASE_STATION
    LATCbits.LATC2 = 0;
#endif
    PWM_LED_STATE = 0;
}

void pwm_LED_toggle() {
    if (PWM_LED_STATE) {
        pwm_LED_off();
    } else {
        pwm_LED_on();
    }
}